$TITLE: JGEA3

* extends model JGEA1 and JGEA2 by examining a tax versus quota,
* economy grows holding either the tax or the quota constant
* and showing the substantial difference between the two

PARAMETERS
 LBAR     labor endowment
 KBAR     capital endowment
 TR       tax on a gross basis (1+tr)
 XQUOTA   maximum allowed level of X production
 WELFARE  welfare;

LBAR = 100;
KBAR = 100;
TR = 0;
XQUOTA = 100;

NONNEGATIVE VARIABLES

 U       activity level for utility or welfare
 X       activity level for X production
 Y       activity level for Y production

 W       price of labor
 R       price of capital
 PX      price of good X
 PY      price of good Y
 PU      price of welfare (expenditure function)

 I       income of the representative consumer
 QR      tariff equivalent of quota on a gross basis;

EQUATIONS

 PRF_U   zero profit for welfare
 PRF_X   zero profit for sector X
 PRF_Y   zero profit for sector Y

 MKT_L   supply-demand balance for primary factor L
 MKT_K   supply-demand balance for primary factor K
 MKT_X   supply-demand balance for commodity X
 MKT_Y   supply-demand balance for commodity Y
 MKT_U   supply-demand balance for welfare

 INC_I   income balance
 QCONS   quota constraint;

*       Zero profit inequalities

PRF_U..      PX**0.5 * PY**0.5 =G= PU;

PRF_X..      W**0.25 * R**0.75 * (1+QR) * (1+TR) =G= PX;

PRF_Y..      W**0.75 * R**0.25 =G= PY;

*       Market clearance inequalities

MKT_L..      LBAR =G= 0.25*(R/W)**0.75*X  +
                      0.75*(R/W)**0.25*Y;

MKT_K..      KBAR =G= 0.75*(W/R)**0.25*X +
                      0.25*(W/R)**0.75*Y;

MKT_X..      X    =G= 0.5*U*PU/PX;

MKT_Y..      Y    =G= 0.5*U*PU/PY;

MKT_U..      U    =G= I/PU;

*       Income balance equation

INC_I..      I =E= LBAR*W + KBAR*R + (TR)*(W**0.25*R**0.75)*X
                                   + (QR)*(W**0.25*R**0.75)*X;

QCONS..      XQUOTA =G= X;


MODEL CLOSED /PRF_U.U, PRF_X.X, PRF_Y.Y,
              MKT_L.W, MKT_K.R, MKT_X.PX, MKT_Y.PY, MKT_U.PU,
              INC_I.I, QCONS.QR /;

*       Chose a numeraire: price of U fixed (.FX) at 1

PU.FX = 1;

*       Set initial values of variables (.L notation after variable)

X.L=20; Y.L=20; U.L = 40; I.L=40;
PX.L=1; PY.L=1; R.L=1; W.L=1; PU.L = 1; QR.L = 0;
TR= 0.25; QR.FX = 0;

SOLVE CLOSED USING MCP;

*    set quota level to duplicate 25% tax in benchmark
XQUOTA = X.L;

* SHOW HOW TO DO MULTIPLE SCENARIOS
* SHOW DIFFERENCE BETWEEN TARIFF AND TRADE COST OF EQUAL RATES

SETS T indexes 25 different gross cost levels         /T1*T25/
     J indexes 2 scenarios: 1 = tariff 2 = trade cost /J1*J2/;

PARAMETERS
 QRATE(T)
 SIZE(T)          net tax or trade cost ratE
 WELFARE(T,J)     welfare normalized to equal 1 in benchmark
 RESULTS(T, *)    formats results in one table;

LOOP(J,
LOOP(T,

QR.UP = +INF; QR.LO = 0;
TR = 0; QR.L = 0;
SIZE(T) = 0.725 + 0.025*ORD(T);
LBAR = 100*SIZE(T);
KBAR = 100*SIZE(T);
TR$(ORD(J) EQ 1) = 0.25;
QR.FX$(ORD(J) EQ 1) = 0;

SOLVE CLOSED USING MCP;

WELFARE(T,J) = U.L;
QRATE(T) = 1;
QRATE(T) = QR.L$(ORD(J) EQ 2);

);
);

RESULTS(T, "SIZE")  = SIZE(T);
RESULTS(T, "QRATE") = QRATE(T);
RESULTS(T, "WELTR") = WELFARE(T, "J1")/WELFARE("T11", "J1");
RESULTS(T, "WELQR") = WELFARE(T, "J2")/WELFARE("T11", "J1");
RESULTS(T, "WELQT") = (WELFARE(T, "J2")/WELFARE("T11", "J1"))/
                      (WELFARE(T, "J1")/WELFARE("T11", "J1"));
DISPLAY RESULTS;

* Write parameter RESULTS to an Excel file JGEA.XLS,
* starting in Sheet3


$EXIT
Execute_Unload 'JGEA.gdx' RESULTS
execute 'gdxxrw.exe JGEA.gdx par=RESULTS rng=SHEET3!'
